*********************************************************************
Do 1983 separately because data are laid out separately

7/20/11:  ADDED IPUMS_ID AND NEW VARS IN 2010 FOR SPM
**********************************************************************;
   filename mar80 'C:\Users\jsulliv4\Documents\CPSdata\1980_Data\07863-0001-Data.txt';
   filename mar81 'C:\Users\jsulliv4\Documents\CPSdata\1981_Data\07535-0001-Data.txt';
   filename mar82 'C:\Users\jsulliv4\Documents\CPSdata\1982_Data\09037-0001-Data.txt';
   filename mar84 'C:\Users\jsulliv4\Documents\CPSdata\1984_Data\08300-0001-Data.txt';
   filename mar85 'C:\Users\jsulliv4\Documents\CPSdata\1985_Data\08432-0001-Data.txt';
   filename mar86 'C:\Users\jsulliv4\Documents\CPSdata\1986_Data\08660-0001-Data.txt';
   filename mar87 'C:\Users\jsulliv4\Documents\CPSdata\1987_Data\08863-0001-Data.txt';
   *filename mar88 'C:\Users\jsulliv4\Documents\CPSdata\1988_Data\09090-0001-Data.txt';
   filename mar88 'C:\Users\jsulliv4\Documents\CPSdata\1988_Data_rewrite\09415-0001-Data.txt';
   filename mar89 'C:\Users\jsulliv4\Documents\CPSdata\1989_Data\09374-0001-Data.txt';
   filename mar90 'C:\Users\jsulliv4\Documents\CPSdata\1990_Data\09475-0001-Data.txt';
   filename mar91 'C:\Users\jsulliv4\Documents\CPSdata\1991_Data\1991-Data.txt';


     %macro read(yr,dir);

           options obs=max mprint;

           data cpsdata.all&yr;
               infile &dir missover lrecl=1000;

   *********************************************************************
   Reading in data from 1980-1988 March CPS.  But 1988-Rewrite follows
   1989.
  **********************************************************************;
           if &yr<=1987 then do;
                   hhid=_n_;
                  input rectype  331 @;
                  if rectype=1 then input
                       state2      39-40
					   hfdval    112-115

			   hseq      1-6
			   hlivqrt   58-59
			   htenure   60
			   htele     126
			   hreg 	 37
			   hmsasz2    51
			   hmsasz    55
			   hpublic   61
			   hlorent   62
			   htotval   72-80
			   hengval   121-124 @;
                 retain state2 hfdval
				hseq hlivqrt htenure htele hreg  hmsasz hpublic hlorent hengval hmsasz2 htotval;
                 if rectype=2 then input
                 famid 1-8
                  fkind 9
                  ftype 10
                   fpersons 11-12

                  fpovcut 181-186
                  ftotval  105-113
				  ftotearn  114-122
                   famlis       189
				   fownu18 153
                  frelu18 165

				 ffrval  35-41
				 fseval  28-34
				 foival  123-131

                   @;
                retain famid fpersons fkind ftype fpovcut ftotval  famlis fownu18 frelu18 ftotearn
					   ffrval fseval foival;

                  if rectype=3 then input
                      pseq       1-6
                      ppos   	   7-8
                      hrslw   16-17
                       pemlr   15
                     refrel2         103
                      famrel          106
                       marstat         107
                       sex         108
                      race2           109
					  reorgn		  113-114
					  age         110-111
                      hga         115-116
                     hgc             117
                      msupwgt         118-128
                       rsnnotw         133
                       wkswrk          134-135
                       hrswk           136-137
                       rsnnotl         145
                      pertype         102
                       wagesal1        191-195
                       selfemp1        196-201
                       farm1           202-207
                       ssinc          208-212
                      ssi         213-216
					  pawval		217-221
					  uiinc			233-237		/* NOTE:  THIS INCLUDES UI, WC AND VET */

					intinc		222-226	
					divinc		227-232
					retinc		238-242
					alimony		243-247
					ptotearn	255-261	
					ptotinc		248-254	

					mcaid		352
                                       ;

              end;

  *********************************************************************
   Reading in data from 1988, 1989, 1990, 1991 March CPS.  Column locations 
   changed after 1988.  But, 1988-rewrite is same as 1989
  **********************************************************************;


  IF 1988<=&yr<=1991 then do;
                  hhid=_n_;
                   input rectype  1 @;
                   if rectype=1 then input
                       state2      40-41
					   hfdval    81-84
			   hseq      2-6
			   hlivqrt   31-32
			   htenure   35
			   htele     36
			   hreg 	 39
			   hmsasz    55
			   hpublic   74
			   hlorent   75
			   htotval   248-255
			   hengval   86-89
                   @;
                   retain state2 hfdval
				hseq hlivqrt htenure htele hreg  hmsasz hpublic hlorent hengval htotval;
                   if rectype=2 then input
                  famid 2-8
                   fkind 9
                   ftype 10
                  fpersons 11-12
                  fownu18 27
                  frelu18 29
                  fpovcut 32-36
                  famlis  37
                  ftotval  205-212
				  ftotearn  213-220

				  	ffrval  64-70
					fseval  56-62
					fsurval  118-124
					foival  198-204
                   @;

               retain  famid fpersons fkind ftype fownu18 frelu18 fpovcut famlis ftotval ftotearn
					   ffrval fseval fsurval foival;

                  if rectype=3 then input
				      pseq       2-6
                      ppos   	   7-8
                      hrslw   76-77
                      pemlr   74
                      refrel2         13-14
                      age         15-16
                      marstat         17
                      sex         20
                      hga             22-23
                      hgc         24
                      race2           25
					  reorgn		  27-28
                      pertype         26
                      famrel          32
                      msupwgt         66-73
                      rsnnotw         170
                      wkswrk          171-172
                      rsnnotl         179
                      hrswk           181-182
                      mainjob         228-233
                      source          234
                  wagesal1        237-241
                  selfemp1        250-254
                  ssi         297-300
				  ssinc          291-295

				  intinc	386-390	
					divinc	393-397
					uiinc	278-282
					wcinc	285-289
					vetinc	317-321
					survinc	337-342
					retinc	379-384
					alimony	421-425
					ptotearn	448-455
					ptotinc		440-447	
					pawval		305-309

					   sur_sc1	323-324
					   sur_sc2	325-326
					   sur_val1	327-331
					   sur_val2	332-336

					   mcaid	470


                  ;

  end;

   if rectype^=3 then delete;

run;

data cpsdata.all&yr;
set cpsdata.all&yr;

ipums_id=_N_;

run;

data cpsdata.all&yr;
set cpsdata.all&yr;

   if &yr<=1988 then do;
	  if fkind=5 and age < 15 then delete;
   end;
   if 1989<=&yr<=1991 then do;
	  if ftype=5 and age < 15 then delete;
   end;

year=&yr;
ref_year=year-1;

run;
proc means;
run;

%mend read;

%read(1980,mar80);
%read(1981,mar81);
%read(1982,mar82);
%read(1984,mar84);
%read(1985,mar85);
%read(1986,mar86);
%read(1987,mar87);
%read(1988,mar88);
%read(1989,mar89);
%read(1990,mar90);
%read(1991,mar91);

proc sort data=cpsdata.all1980_bak;
by hhid;
run;
proc sort data=cpsdata.all1980;
by hhid;
run;
proc compare base=cpsdata.all1980_bak
             compare=cpsdata.all1980
			 novalues listall;
run;
